' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Partial Class CheckAvailability
  Inherits System.Web.UI.Page

  Private Sub LoadData()
    If Not calAppointmentDate.SelectedDate = DateTime.MinValue Then
      ' Z kalendarza wybrano poprawn dat. Pobierz arkusz rezerwacji w powi go z kontrolk TimeSheet.
      TimeSheet1.DataSource = _
               AppointmentManager.GetTimeSheet(calAppointmentDate.SelectedDate)
      TimeSheet1.SelectedDate = calAppointmentDate.SelectedDate
      TimeSheet1.DataBind()
    End If
  End Sub

  Protected Sub calAppointmentDate_SelectionChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles calAppointmentDate.SelectionChanged
    If calAppointmentDate.SelectedDate.CompareTo(DateTime.Now.Date) < 0 Then
      ' Wybrano nieprawidlow dat; wywietl komunikat o bdzie i poka ponownie kalendarz.
      valSelectedDate.IsValid = False
      divCalendar.Style.Item("display") = "block"
    Else
      ' Ukryj kalendarz
      divCalendar.Style.Item("display") = "none"
      lblSelectedDate.Visible = True
      lblSelectedDate.Text = "Wybrae: <strong>" & calAppointmentDate.SelectedDate.ToShortDateString() & "</strong>"
      lblInstructions.Text = "&nbsp;&nbsp;&nbsp;Kliknij ponownie ikon kalendarza, aby wybra inn dat:"
      LoadData()
    End If
  End Sub

  Protected Sub calAppointmentDate_VisibleMonthChanged(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.MonthChangedEventArgs) Handles calAppointmentDate.VisibleMonthChanged
    ' Uytkownik przeszed do innego miesica; poka ponownie kalendarz, aby mona byo wybra dzie.
    divCalendar.Style.Item("display") = "block"
  End Sub

  Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
    ' Przy pocztkowym adowaniu strony, ukryj kalendarz za pomoc waciwoci CSS.
    divCalendar.Style.Item("display") = "none"
  End Sub
End Class
